<?php
require "../config.php";
require "../includes/auth.php";

ob_start();

$order_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($order_id <= 0) {
    die("Invalid order ID.");
}

// Fetch order details
$stmt = $pdo->prepare("
    SELECT o.id, o.user_id, o.course_id, u.telegram_id, c.group_link
    FROM orders o
    JOIN users u ON o.user_id = u.id
    JOIN courses c ON o.course_id = c.id
    WHERE o.id = ?
");
$stmt->execute([$order_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    die("Order not found.");
}

// Generate token
$token = bin2hex(random_bytes(16));

// Save token + paid status
$update = $pdo->prepare("
    UPDATE orders
    SET status='approved', access_token=?, used=0
    WHERE id=?
");
$update->execute([$token, $order_id]);

// Masked join link
$join_url = "https://bengalbook.site/join_group.php?token=$token";

/* --- Send Telegram Message --- */
$chat_id = $order["telegram_id"];

$msg = "🎉 <b>Payment Approved!</b>\n\n" .
       "Your course is now activated.\n\n" .
       "👇 <b>Click below to join the private Telegram group:</b>\n$join_url\n\n" .
       "⚠ This link is <b>one-time use only</b>.\n\n" .
       "🔖 <i>Developed by HostKash</i>";

$bot_url = "https://api.telegram.org/bot".BOT_TOKEN."/sendMessage";

$payload = [
    "chat_id" => $chat_id,
    "text" => $msg,
    "parse_mode" => "HTML"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $bot_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_exec($ch);
curl_close($ch);

header("Location: orders.php?success=1");
exit;
?>
