<?php
session_start();
require "../config.php";

// Simple admin login protection
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// GET all institutes
$institutes = $pdo->query("SELECT * FROM institutes ORDER BY name ASC")->fetchAll();

// get selected institute
$current_inst = intval($_GET['inst'] ?? 0);

// FETCH branches of selected institute
$branches = [];
if ($current_inst > 0) {
    $stmt = $pdo->prepare("SELECT * FROM branches WHERE institute_id=? ORDER BY id DESC");
    $stmt->execute([$current_inst]);
    $branches = $stmt->fetchAll();
}

/* -----------------------------------
       ADD BRANCH
----------------------------------- */
if (isset($_POST['add'])) {
    $inst = intval($_POST['inst']);
    $name = trim($_POST['name']);

    if ($inst > 0 && $name !== "") {
        $stmt = $pdo->prepare("INSERT INTO branches (institute_id, name) VALUES (?, ?)");
        $stmt->execute([$inst, $name]);

        header("Location: manage_branches.php?inst=" . $inst);
        exit;
    }
}

/* -----------------------------------
       DELETE BRANCH
----------------------------------- */
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);

    // find institute so redirect works
    $find = $pdo->prepare("SELECT institute_id FROM branches WHERE id=?");
    $find->execute([$id]);
    $f = $find->fetch();

    if ($f) {
        $pdo->prepare("DELETE FROM branches WHERE id=?")->execute([$id]);
        header("Location: manage_branches.php?inst=" . $f['institute_id']);
        exit;
    }
}

/* -----------------------------------
       UPDATE BRANCH
----------------------------------- */
if (isset($_POST['update'])) {
    $id = intval($_POST['id']);
    $name = trim($_POST['name']);

    if ($id > 0 && $name !== "") {
        $pdo->prepare("UPDATE branches SET name=? WHERE id=?")->execute([$name, $id]);
    }

    header("Location: manage_branches.php?inst=" . intval($_POST['inst']));
    exit;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Branches</title>

    <!-- BOOTSTRAP -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Dark Modern Theme Matching Your Previous Page -->
    <style>
        :root {
            --bg-dark: #0d1117;
            --card-bg: #161b22;
            --border-color: #30363d;
            --text-main: #e6edf3;
            --input-bg: #0d1117;
        }

        body {
            background: var(--bg-dark);
            color: var(--text-main);
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            padding-bottom: 50px;
        }

        .card-custom {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 14px;
            padding: 25px;
        }

        .form-control, .form-select {
            background: var(--input-bg);
            border: 1px solid var(--border-color);
            color: var(--text-main);
            border-radius: 10px;
        }
        .form-control:focus, .form-select:focus {
            border-color: #58a6ff;
            box-shadow: 0 0 0 3px rgba(88,166,255,0.2);
        }

        .table {
            color: var(--text-main);
        }
        .table th {
            background: #1f2731 !important;
            color: white;
        }

        .modal-content {
            background: #161b22;
            color: var(--text-main);
            border-radius: 12px;
        }
        .btn-outline-danger:hover {
            background: #dc3545;
        }
        .btn-outline-primary:hover {
            background: #0d6efd;
        }
    </style>

</head>
<body>

<div class="container py-5">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="bi bi-diagram-3 text-primary"></i> Manage Branches</h2>
        <a href="dashboard.php" class="btn btn-outline-secondary">
            <i class="bi bi-speedometer2"></i> Dashboard
        </a>
    </div>

    <!-- Institute Selector -->
    <div class="card-custom mb-4">
        <form method="GET">
            <label class="form-label text-info"><i class="bi bi-building"></i> Select Institute</label>
            <select name="inst" class="form-select form-select-lg" onchange="this.form.submit()">
                <option value="">-- Choose Institute --</option>
                <?php foreach ($institutes as $i): ?>
                    <option value="<?= $i['id'] ?>" <?= ($current_inst == $i['id']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($i['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </form>
    </div>

    <?php if ($current_inst): ?>

    <!-- Add Branch -->
    <div class="card-custom mb-4">
        <h4 class="text-success"><i class="bi bi-plus-circle"></i> Add Branch</h4>

        <form method="POST" class="mt-3">
            <input type="hidden" name="inst" value="<?= $current_inst ?>">

            <div class="row g-3">
                <div class="col-md-6">
                    <input type="text" name="name" class="form-control" placeholder="Branch Name (e.g. Mechanical)" required>
                </div>
                <div class="col-md-3">
                    <button type="submit" name="add" class="btn btn-success w-100">
                        <i class="bi bi-plus-circle"></i> Add
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Branch List -->
    <div class="card-custom">
        <h5 class="mb-3"><i class="bi bi-list-ul"></i> Existing Branches (<?= count($branches) ?>)</h5>

        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Branch Name</th>
                    <th class="text-end">Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($branches as $b): ?>
                    <tr>
                        <td><?= $b['id'] ?></td>
                        <td><?= htmlspecialchars($b['name']) ?></td>
                        <td class="text-end">

                            <!-- Edit Button -->
                            <button class="btn btn-outline-primary btn-sm"
                                    onclick="editBranch(<?= $b['id'] ?>, `<?= htmlspecialchars($b['name'], ENT_QUOTES) ?>`)">
                                <i class="bi bi-pencil"></i> Edit
                            </button>

                            <!-- Delete -->
                            <a href="?delete=<?= $b['id'] ?>"
                               onclick="return confirm('Delete this branch?');"
                               class="btn btn-outline-danger btn-sm">
                                <i class="bi bi-trash"></i> Delete
                            </a>

                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

    </div>

    <?php endif; ?>

</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header border-secondary">
                <h5 class="modal-title"><i class="bi bi-pencil-square"></i> Edit Branch</h5>
                <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>

            <form method="POST">
                <div class="modal-body">

                    <input type="hidden" id="edit_id" name="id">
                    <input type="hidden" name="inst" value="<?= $current_inst ?>">

                    <label class="form-label">Branch Name</label>
                    <input type="text" id="edit_name" name="name" class="form-control" required>

                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="update" class="btn btn-success">
                        <i class="bi bi-check2-all"></i> Update
                    </button>
                </div>
            </form>

        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
function editBranch(id, name) {
    document.getElementById("edit_id").value = id;
    document.getElementById("edit_name").value = name;
    new bootstrap.Modal(document.getElementById('editModal')).show();
}
</script>

</body>
</html>
